#include  <hic.h>
#include  <string.h>
#include  "typedef.h"
#include  "macrodef.h"
#include  "rw_flash.h"

/**********************************************
check_empty
  ѯFlashǷΪ
ֵword_addr:Flashʼַ;num:յֽ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 check_empty(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        *buf_Addr = Read_SingleWord(word_addr);
		*(buf_Addr+1) = Read_SingleWord(word_addr)>>8;
		if(*buf_Addr != 0xFF || *(buf_Addr+1) != 0xFF)
		{
			return  FAILED;
		}
        ++word_addr;
    }
    return  SUCCESS;
}
/**********************************************
Read_SingleWord
  Flashһ
ֵaddr:Flashַ
ֵ
ֵӦFlashַе
**********************************************/
u16 Read_SingleWord(u16  addr)
{
    FRAL = addr;
    FRAH = addr >> 8;
    __Asm  TBR;
    return(((u16)ROMDH << 8) + ROMDL);
}
/**********************************************
Read_Cont
  Flash
ֵword_addr:Flashַ; *buf_Addr:ݱַ; num:ֽ
ֵFlashе
ֵSUCCESSFAILED
**********************************************/
u8 Read_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        *buf_Addr = Read_SingleWord(word_addr);
		*(++buf_Addr) = Read_SingleWord(word_addr)>>8;
        word_addr++;
        ++buf_Addr;
    }
    return  SUCCESS;
}
/**********************************************
Erase_Page
  һҳFlash
ֵaddrҳڵĵַ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Erase_Page(u16  page_addr)
{
	FRAL = page_addr & 0xFF;
    FRAH = (page_addr >> 8) & 0xFF;	//ַֽ
	FRALN = ~FRAL & 0xFF;
	FRAHN = ~FRAH & 0xFF;
	IAPCLR = 1;			//IAP״̬
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }
	IAPUL = 0xA5;		//
	IAPERSS = 0xAE;		//
	__Asm NOP;
    while(!IAP_DONE)	//ȴ
    {
		;
        //if(IAP_LVDIF)
			//return FAILED;
    }
	IAPUL = 0x00;		//
	GIE=1;
	return SUCCESS;	
}
/**********************************************
Write_SingleWord
  FlashӦַдһֵ
ֵaddrFlashַ; word_dat:
ֵ
ֵ
**********************************************/
void Write_SingleWord(u16  addr, u16 word_dat)
{
	u8 timer_cnt_temp;
	while(GIE == 1)     //ȫж
    {
        GIE = 0;
    }
	timer_cnt_temp = T10;//
	T10 = 6;			 //IAPʱ250*32us
    FRAL = addr;		//ַֽ
    FRAH = addr >> 8;	//ַֽ
	FRALN = ~FRAL;
	FRAHN = ~FRAH;
    ROMDL = word_dat;	   //ݵֽ
    ROMDH = word_dat >> 8; //ݸֽ
    ROMDLN=~ROMDL;
	ROMDHN=~ROMDH;      
	TOEN = 1;			//ʹTimeoutʱ
	T10IF = 0;
	IAPCLR = 1;			//IAP״̬
	IAPUL = 0xA5;		//
	IAPPRGS = 0xD5;		//д
    __Asm NOP;
	while(!IAP_DONE)	//ȴ
	{
		if(IAP_LVDIF)break;
	}
	IAPUL = 0x00;		//
	T10 = timer_cnt_temp;
	GIE = 1 ;
}
/**********************************************
Write_SingleWord
  Flashд
ֵword_addrFlashʼַ;buf_Addr:Ҫдݵʼַ num:ݸ
ֵ
ֵSUCCESSFAILED
**********************************************/
u8 Write_Cont(u16  word_addr, u8 *buf_Addr, u16 num)
{
    u16  i;
    for(i = 0; i < (num / 2); i++)
    {
        Write_SingleWord(word_addr, *((u16 *)buf_Addr));
        word_addr++;
        buf_Addr += 2;
    }
    return  SUCCESS;
}